;-----------------------------------------------------------------------------
; MEKA - Patches Database
; http://www.smspower.org/meka
;-----------------------------------------------------------------------------
; Patches available in the default MEKA distribution are meant to fix
; or improve game/software behavior. This patching functionnality can 
; also be used as a basic cheating tool.
; For technical help, check http://www.smspower.org/dev
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Syntax:
;   [crc]
;   commands...
;
; CRC can be in any of the following format:
;  - [*]                                Match and apply patch to any file
;  - [xxxxxxxxxxxxxxxx]                 Match meka.nam format CRC
;  - [mekacrc:xxxxxxxxxxxxxxxx]         "
;  - [crc32:xxxxxxxx]                   Match CRC32
;
; Commands:
;  - ROM[<addr>] = <byte> [,<byte>..]   Write given byte(s) at given ROM address, on loading
;  - MEM[<addr>] = <byte> [,<byte>..]   Write given byte(s) at given memory map address, every 1/60th second 
;
; In memory map, RAM range is C000-DFFF.
;
; All values are in hexadecimal base.
;
; An ACTION REPLAY code can be easily converted in MEKA patching format:
;     00xx-xxyy -> MEM[xxxx] = yy
; eg: 00CF-4A02 -> MEM[CF4A] = 02
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Generic, pause-button hack [SMS]
;-----------------------------------------------------------------------------
; Can be useful for VGM logging purpose. Read instruction at:
;   http://www.smspower.org/music/tools/pausehack/index.shtml
; Author: Maxim
;-----------------------------------------------------------------------------
;[*]
;ROM[0066] = FB, 18, FE
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Battle Out Run
;-----------------------------------------------------------------------------
; Activate and enforce FM Unit support.
; Author: Sonic of 8!
;-----------------------------------------------------------------------------
;[crc32: c19430ce]
;MEM[DE00] = 01
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Double Hawk
;-----------------------------------------------------------------------------
; Activate and enforce FM Unit support.
; Author: Sonic of 8!
;-----------------------------------------------------------------------------
;[crc32: 8370f6cd]
;MEM[DD00] = 01
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Dynamite Dux
;-----------------------------------------------------------------------------
; Activate and enforce FM Unit support.
; Author: Sonic of 8!
;-----------------------------------------------------------------------------
;[crc32: 0e1cc1e0]
;MEM[D000] = 01
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Rambo III
;-----------------------------------------------------------------------------
; Activate and enforce FM Unit support.
; Author: Sonic of 8!
;[crc32: da5a7013]
;MEM[DE80] = 01
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Summer Games
;-----------------------------------------------------------------------------
; Activate and enforce FM Unit support.
; Author: Sonic of 8!
;[crc32: 8da5c93f]
;MEM[C001] = 01
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Super Basketball [Demo]
;-----------------------------------------------------------------------------
; Activate and enforce FM Unit support.
; Author: Sonic of 8!
;[crc32: 0dbf3b4a]
;MEM[C001] = 01
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Wonder Boy III: The Dragon's Trap [SMS]
;-----------------------------------------------------------------------------
; Activate FM Unit support in European/US mode (original game allows it only in Japanese mode)
; Author: Bock
;-----------------------------------------------------------------------------
[crc32: 679e1676]
ROM[025B] = 00, 00
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Monica em: O Resgate [SMS]
;-----------------------------------------------------------------------------
; Activate FM Unit support in European/US mode (original game allows it only in Japanese mode)
; Author: Bock
;-----------------------------------------------------------------------------
[crc32: 22cca9bb]
ROM[025B] = 00, 00
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; American Pro Football [SMS]
;-----------------------------------------------------------------------------
; Fix a bug preventing the game to function if FM Unit is detected.
; Author: Bock
;-----------------------------------------------------------------------------
[crc32: 3727d8b2]
ROM[05A7] = AF, 00
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Walter Payton Football [SMS]
; Fix a bug preventing the game to function if FM Unit is detected.
; Author: Bock
;-----------------------------------------------------------------------------
[crc32: 3d55759b]
ROM[0592] = AF, 00
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Sports Pad Soccer [SMS]
;-----------------------------------------------------------------------------
; Fix a bug preventing the game to function if FM Unit is not detected.
; Author: Bock
;-----------------------------------------------------------------------------
[crc32: 41c948bf]
ROM[0173] = 0C
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Wanted [SMS]
;-----------------------------------------------------------------------------
; Fix a bug preventing the game to function if FM Unit is detected.
; Author: Bock
;-----------------------------------------------------------------------------
[crc32: 5359762d]
ROM[045D] = 00, 00
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Sega Basic Level 3 1.0 (Export) [SC-3000]
;-----------------------------------------------------------------------------
; Bad dump, byte 0 is incorrect. Patch it.
; Author: Ricardo Bittencourt
;-----------------------------------------------------------------------------
[crc32: 155fd01f]
ROM[0000] = C3
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Sega Basic Level 3 1.1 (Japanese) [SC-3000]
;-----------------------------------------------------------------------------
; Hardware check patch
; Author: Bock
;-----------------------------------------------------------------------------
[crc32: 6aa0279d]
ROM[689c] = 00, 00, 00
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Music [BAD] [SC-3000]
;-----------------------------------------------------------------------------
; This dump has byte 0 incorrect. Patch it.
; Author: Ricardo Bittencourt
;-----------------------------------------------------------------------------
[crc32: b67ea1c4]
ROM[0000] = C3
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; 20 em 1 [SMS]
;-----------------------------------------------------------------------------
; Disable the first controller port read, done outside of a loop.
; Inputs are updated by interrupt, and at the time the value was loaded,
; interrupts did not happens. It is very tricky and probably due to bad 
; programming and timing issues, but I don't know why it doesn't emulate well.
; Author: Bock
;-----------------------------------------------------------------------------
[crc32: f0f35c22]
ROM[0FB5] = DD, 4E, FF
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Alex Kidd in Miracle World BIOS [SMS]
;-----------------------------------------------------------------------------
; Allows the BIOS dump to run as a cartridge.
;-----------------------------------------------------------------------------
[crc32: cf4a09ea]
ROM[17EDE] = 00, 00, 00
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Alex Kidd in Miracle World BIOS [SMS] (KR)
;-----------------------------------------------------------------------------
; Allows the BIOS dump to run as a cartridge.
;-----------------------------------------------------------------------------
[crc32: 9c5bad91]
ROM[1FA13] = 00, 00, 00
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Hang On / Safari Hunt BIOS [SMS]
;-----------------------------------------------------------------------------
; Allows the BIOS dump to run as a cartridge.
;-----------------------------------------------------------------------------
[crc32: 91e93385]
ROM[1C12F] = 00, 00, 00
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; SMS v2.0 BIOS [SMS]
; Allows the BIOS dump to run as a cartridge.
;-----------------------------------------------------------------------------
[crc32: b3d854f8]
ROM[02C5] = 00
;ROM[114] = 00, 00, 00
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Sonic the Hedgehog BIOS [SMS]
; Allows the BIOS dump to run as a cartridge.
;-----------------------------------------------------------------------------
[crc32: 81c3476b]
ROM[26FA] = 00, 00, 00
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Majesco BIOS [GG]
;-----------------------------------------------------------------------------
[crc32: 0ebea9d4]
ROM[00A7] = 00
;-----------------------------------------------------------------------------
